#include <iostream>
#include <vector>
#include <algorithm>
#include <set>

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, q;
    cin >> n >> q;

    vector<int> a(n);
    vector<int> pos(n + 2); // pozicije brojeva od 1 do N

    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        pos[a[i]] = i;
    }

    // Broj prekida: poz[x] > poz[x+1]
    int cnt = 0;
    for (int x = 1; x < n; ++x) {
        if (pos[x] > pos[x + 1])
            ++cnt;
    }

    cout << cnt << '\n';

    while (q--) {
        int i, j;
        cin >> i >> j;
        --i; --j;

        if (i == j) {
            cout << cnt << '\n';
            continue;
        }

        // Brojevi koji se menjaju
        int x = a[i];
        int y = a[j];

        // Set brojeva za koje proveravamo prekide
        set<int> affected;

        for (int v : {x - 1, x, y - 1, y}) {
            if (v >= 1 && v < n) {
                affected.insert(v);
            }
        }

        // Skini stare prekide
        for (int v : affected) {
            if (pos[v] > pos[v + 1]) --cnt;
        }

        // Zamena u nizu
        swap(a[i], a[j]);
        swap(pos[x], pos[y]);

        // Dodaj nove prekide
        for (int v : affected) {
            if (pos[v] > pos[v + 1]) ++cnt;
        }

        cout << cnt << '\n';
    }

    return 0;
}